/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "..\x86emu.h"

//---------------------------------------------------------------------------------
//SHL
int op_shl(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    if (s->flags & SRC_IMM){
             src=s->nsrc & 0x1F;        //not bigger than 31

    }else if (s->flags & SRC_REG){
          int src2=thread.Exx[1];
          memcpy(&src,&src2,1);
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          int n=thread.Exx[s->ndest];
          n=n << src;
          if (s->flags & DEST_BITS32){src=n; memcpy(&thread.Exx[s->ndest],&src,4);result=thread.Exx[s->ndest];}
          if (s->flags & DEST_BITS16){src=n; memcpy(&thread.Exx[s->ndest],&src,2);result=thread.Exx[s->ndest];}
          if (s->flags & DEST_BITS8){      
             char* dest2=(char*)&thread.Exx[s->ndest];
             if (s->ndest >3){
                          dest2=(char*)(&thread.Exx[s->ndest-4]);
                          dest2++;
             };
             *dest2 =*dest2 << src;
             result=*dest2 &0xff;        
          };
          
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dword n=*ptr;
          dest=n;
          if (s->flags & DEST_BITS32){
             dword n=*ptr;
             n=(n & 0xffffffff) << src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
             
          };
          if (s->flags & DEST_BITS16){
             short n=*ptr;
             n=(n & 0xffff) << src;      
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=*ptr;
             n=(n & 0xff) << src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };    
    thread.updateflags(dest,0,result,0);   
    thread.EFlags &= (EFLG_PF | EFLG_ZF | EFLG_SF |EFLG_SYS);
    if (dest >> (32-src))thread.EFlags |=EFLG_CF;
    //cout << "dest= "<<(int*)dest << "\nresult= " << (int*)result<<"\nflags= "<< (int*)thread.EFlags << "\n";   
};
//---------------------------------------------------------------------------------
//SHR
int op_shr(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    if (s->flags & SRC_IMM){
             src=s->nsrc & 0x1F;        //not bigger than 31

    }else if (s->flags & SRC_REG){
          int src2=thread.Exx[1];
          memcpy(&src,&src2,1);
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          int n=thread.Exx[s->ndest];
          if (s->flags & DEST_BITS32){n=n >> src;src=n; memcpy(&thread.Exx[s->ndest],&src,4);result=thread.Exx[s->ndest];}
          if (s->flags & DEST_BITS16){n &= 0xffff;n=n >> src;src=n; memcpy(&thread.Exx[s->ndest],&src,2);result=thread.Exx[s->ndest];}
          if (s->flags & DEST_BITS8){      
             char* dest2=(char*)&thread.Exx[s->ndest];
             if (s->ndest >3){
                          dest2=(char*)(&thread.Exx[s->ndest-4]);
                          dest2++;
             };
             dest=*dest2;
             n=0;
             n=*dest2 & 0xff;
             *dest2 = n >> src;
             result=*dest2 & 0xff;
          };
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dword n=*ptr;
          dest=n;
          if (s->flags & DEST_BITS32){
             dword n=*ptr;
             n=(n & 0xffffffff) >> src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
             
          };
          if (s->flags & DEST_BITS16){
             short n=*ptr;
             n=(n & 0xffff) >> src;      
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=*ptr;
             n=(n & 0xff) >> src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };    
    thread.updateflags(dest,0,result,0);   
    thread.EFlags &= (EFLG_PF | EFLG_ZF | EFLG_SF |EFLG_SYS);
    //if (dest >> (32-src))thread.EFlags |=EFLG_CF;
    if (dest & 1)thread.EFlags |=EFLG_CF;
    //cout << "dest= "<<(int*)dest << "\nresult= " << (int*)result<<"\nflags= "<< (int*)thread.EFlags << "\n";   
};
//---------------------------------------------------------------------------------
//ROL
int op_rol(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    if (s->flags & SRC_IMM){
             src=s->nsrc;

    }else if (s->flags & SRC_REG){
          int src2=thread.Exx[1];
          memcpy(&src,&src2,1);
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          int n=thread.Exx[s->ndest];
          //n=n << src + (n>> 32-src);src=n;
          if (s->flags & DEST_BITS32){
                       src=src & 0x1F;
                       n=((n & 0xffffffff) << src) + ((n & 0xffffffff) >> (32-src));
                       src=n;memcpy(&thread.Exx[s->ndest],&src,4);
                       result=thread.Exx[s->ndest];
                       };
          if (s->flags & DEST_BITS16){src=src & 0xF;
              n=((n & 0xffff) << src) + ((n & 0xffff)>> (16-src));
              src=n;
              memcpy(&thread.Exx[s->ndest],&src,2);
              result=thread.Exx[s->ndest];
          };
          if (s->flags & DEST_BITS8){      
             char* dest2=(char*)&thread.Exx[s->ndest];
             if (s->ndest >3){
                          dest2=(char*)(&thread.Exx[s->ndest-4]);
                          dest2++;
             };  
             n=*dest2;
             src=src & 7;
             *dest2=((n & 0xff)<< src) +((n & 0xff)>> (8-src));
             result=*dest2 &0xff; 
             };
          
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dword n=*ptr;
          dest=n;
          if (s->flags & DEST_BITS32){
             dword n=*ptr;
             n=(n << src) + ((n & 0xffffffff)>> 32-src);
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
             
          };
          if (s->flags & DEST_BITS16){
             short n=*ptr;
             n=(n << src) + ((n & 0xffff)>> 16-src);      
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=*ptr;
             n=(n << src) + ((n & 0xff)>> (8-src));
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };    
    thread.updateflags(dest,0,result,0);   
    thread.EFlags &= (EFLG_PF | EFLG_ZF | EFLG_SF |EFLG_SYS);
    if (dest >> (32-src))thread.EFlags |=EFLG_CF;
    //cout << "dest= "<<(int*)dest << "\nresult= " << (int*)result<<"\nflags= "<< (int*)thread.EFlags << "\n";   
};
//---------------------------------------------------------------------------------
//ROR
int op_ror(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    if (s->flags & SRC_IMM){
             src=s->nsrc;

    }else if (s->flags & SRC_REG){
          int src2=thread.Exx[1];
          memcpy(&src,&src2,1);
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          int n=thread.Exx[s->ndest];
          //n=n << src + (n>> 32-src);src=n;
          if (s->flags & DEST_BITS32){
                       src=src & 0x1F;
                       n=((n & 0xffffffff) >> src) + ((n & 0xffffffff)<<(32-src));
                       src=n; 
                       memcpy(&thread.Exx[s->ndest],&src,4);
                       result=thread.Exx[s->ndest];
          };
          if (s->flags & DEST_BITS16){
                       src=src & 0xF;
                       n=((n & 0xffff) >> src) + ((n & 0xffff)<< (16-src));
                       src=n; 
                       memcpy(&thread.Exx[s->ndest],&src,2);
                       result=thread.Exx[s->ndest];
                       };
          if (s->flags & DEST_BITS8){      
             char* dest2=(char*)&thread.Exx[s->ndest];
             if (s->ndest >3){
                          dest2=(char*)(&thread.Exx[s->ndest-4]);
                          dest2++;
             };  
             src=src & 0x7;
             *dest2=((*dest2 & 0xff)>> src) +((*dest2 & 0xff)<< (8-src));
             result=*dest2 &0xff; 
             };
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dword n=*ptr;
          dest=n;
          if (s->flags & DEST_BITS32){
             dword n=*ptr;
             n=((n & 0xffffffff) >> src) + ((n & 0xffffffff)<< 32-src);
            // __asm(
              //     "mov %cl,(src)"
                   //"rorl (n),%cl"
               //   );
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
             
          };
          if (s->flags & DEST_BITS16){
             short n=*ptr;
             n=((n & 0xffff) >> src )+ ((n & 0xffff)<< 16-src);      
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=*ptr;
             n=((n & 0xff) >> src) + ((n & 0xff)<< (8-src));
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };    
    thread.updateflags(dest,0,result,0);   
    thread.EFlags &= (EFLG_PF | EFLG_ZF | EFLG_SF |EFLG_SYS);
    if (dest >> (32-src))thread.EFlags |=EFLG_CF;
    //cout << "dest= "<<(int*)dest << "\nresult= " << (int*)result<<"\nflags= "<< (int*)thread.EFlags << "\n";   
};
//=====================================================================================================
//SAR
int op_sar(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    if (s->flags & SRC_IMM){
             src=s->nsrc & 0x1F;        //not bigger than 31

    }else if (s->flags & SRC_REG){
          int src2=thread.Exx[1];
          memcpy(&src,&src2,1);
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          int n=thread.Exx[s->ndest];
          __asm(
              "sar %%cl,%%edx"
              :"=d"(n)                       //saves in eax,edx  
              :"c"(src),"d"(n)                 //the inputs
              );
          if (s->flags & DEST_BITS32){src=n; memcpy(&thread.Exx[s->ndest],&src,4);result=thread.Exx[s->ndest];}
          if (s->flags & DEST_BITS16){src=n; memcpy(&thread.Exx[s->ndest],&src,2);result=thread.Exx[s->ndest];}
          if (s->flags & DEST_BITS8){
                   if (s->ndest >3){
                      n=thread.Exx[s->ndest-4];  
                      __asm(
                          "sar %%cl,%%dh"
                          :"=d"(n)                       //saves in eax,edx  
                          :"c"(src),"d"(n)                 //the inputs
                          );
                      src=n;
                      memcpy(&thread.Exx[s->ndest-4],&src,2);          
                   }else{           
                    __asm(
                          "sar %%cl,%%edx"
                          :"=d"(n)                       //saves in eax,edx  
                          :"c"(src),"d"(n)                 //the inputs
                          );
                    src=n;
                    result=n &0xff;   
                    memcpy(&thread.Exx[s->ndest],&src,1);
                    };   
                    
          };
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dword n=*ptr;
          dest=n;
          if (s->flags & DEST_BITS32){
             dword n=*ptr;
             dword num=(n & 0xffffffff);
             __asm(
              "sar %%cl,%%edx"
              :"=d"((num))              //saves in eax,edx  
              :"c"(src),"d"(n)                 //the inputs
              );
             //n=(n & 0xffffffff) >> src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
             
          };
          if (s->flags & DEST_BITS16){
             short n=*ptr;
             dword num=n & 0xffff;
             __asm(
              "sar %%cl,%%dx"
              :"=d"(num)                       //saves in eax,edx  
              :"c"(src),"d"(n)                 //the inputs
              );
            // n=(n & 0xffff) >> src;      
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=*ptr;
             dword num=n & 0xff;
             __asm(
              "sar %%cl,%%dl"
              :"=d"(num)                       //saves in eax,edx  
              :"c"(src),"d"(n)                 //the inputs
              );
             //n=(n & 0xff) >> src;
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };    
    thread.updateflags(dest,0,result,0);   
    thread.EFlags &= (EFLG_PF | EFLG_ZF | EFLG_SF |EFLG_SYS);
    if (dest & 1)thread.EFlags |=EFLG_CF;
    //cout << "dest= "<<(int*)dest << "\nresult= " << (int*)result<<"\nflags= "<< (int*)thread.EFlags << "\n";   
};
//---------------------------------------------------------------------------------
//RCL
int op_rcl(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    if (s->flags & SRC_IMM){
             src=s->nsrc & 0x1F;        //not bigger than 31

    }else if (s->flags & SRC_REG){
          int src2=thread.Exx[1];
          memcpy(&src,&src2,1);
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          int n=thread.Exx[s->ndest];
          //n=n << src + (n>> 32-src);src=n;
          if (s->flags & DEST_BITS32){
                       __asm("clc");
                       if (thread.EFlags & EFLG_CF)__asm("stc");
                       __asm(
                              "rcl %%cl,%%edx"
                              :"=d"(n)                       //saves in eax,edx  
                              :"c"(src),"d"(n)                 //the inputs
                              );
                       src=n;
                       memcpy(&thread.Exx[s->ndest],&src,4);
                       };
          if (s->flags & DEST_BITS16){
                       __asm("clc");
                       if (thread.EFlags & EFLG_CF)__asm("stc");
                      __asm(
                              "rcl %%cl,%%dx"
                              :"=d"(n)                       //saves in eax,edx  
                              :"c"(src),"d"(n)                 //the inputs
                              );
                       src=n;
                       memcpy(&thread.Exx[s->ndest],&src,2);
                        };
          if (s->flags & DEST_BITS8){
                       if (s->ndest <4){
                           __asm("clc");
                           if (thread.EFlags & EFLG_CF)__asm("stc");             
                           __asm(
                                  "rcl %%cl,%%dl"
                                  :"=d"(n)                       //saves in eax,edx  
                                  :"c"(src),"d"(n)                 //the inputs
                                  );
                           src=n;
                           memcpy(&thread.Exx[s->ndest],&src,1);
                       }else{
                             n=thread.Exx[s->ndest-4];
                             __asm("clc");
                             if (thread.EFlags & EFLG_CF)__asm("stc");
                             __asm(
                              "rcl %%cl,%%dh"
                              :"=d"(n)                       //saves in eax,edx  
                              :"c"(src),"d"(n)                 //the inputs
                              );
                              src=n;
                              memcpy(&thread.Exx[s->ndest-4],&src,4);
                              };
                       };
          result=thread.Exx[s->ndest];
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dword n=*ptr;
          dest=n;
          if (s->flags & DEST_BITS32){
             dword n=*ptr;
             __asm("clc");
             if (thread.EFlags & EFLG_CF)__asm("stc");
             __asm(
                   "rcl %%cl,%%edx"
                   :"=d"(n)                       //saves in eax,edx  
                   :"c"(src),"d"(n)                 //the inputs
             );
             
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
             
          };
          if (s->flags & DEST_BITS16){
             short n=*ptr;
             __asm("clc");
             if (thread.EFlags & EFLG_CF)__asm("stc");
             __asm(
                   "rcl %%cl,%%dx"
                   :"=d"(n)                       //saves in eax,edx  
                   :"c"(src),"d"(n)                 //the inputs
             );
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=*ptr;
             __asm("clc");
             if (thread.EFlags & EFLG_CF)__asm("stc");
             __asm(
                   "rcl %%cl,%%dl"
                   :"=d"(n)                       //saves in eax,edx  
                   :"c"(src),"d"(n)                 //the inputs
             );
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };    
    thread.updateflags(dest,0,result,0);   
    thread.EFlags &= (EFLG_PF | EFLG_ZF | EFLG_SF |EFLG_SYS);
    if (dest >> (32-src))thread.EFlags |=EFLG_CF;
    //cout << "dest= "<<(int*)dest << "\nresult= " << (int*)result<<"\nflags= "<< (int*)thread.EFlags << "\n";   
};
//---------------------------------------------------------------------------------
//RCR
int op_rcr(Thread& thread,ins_disasm* s){
    //first we will test the source and get the value that we will put in the dest in src variable
    dword dest,result;
    int src=0;
    if (s->flags & SRC_IMM){
             src=s->nsrc & 0x1F;        //not bigger than 31

    }else if (s->flags & SRC_REG){
          int src2=thread.Exx[1];
          memcpy(&src,&src2,1);
    };
    // now we have the value of the src that we will put it in the dest now we will test the dest
    if (s->flags & DEST_REG){
          dest=thread.Exx[s->ndest];
          int n=thread.Exx[s->ndest];
          //n=n << src + (n>> 32-src);src=n;
          if (s->flags & DEST_BITS32){
                       __asm("clc");
                       if (thread.EFlags & EFLG_CF)__asm("stc");
                       __asm(
                              "rcr %%cl,%%edx"
                              :"=d"(n)                       //saves in eax,edx  
                              :"c"(src),"d"(n)                 //the inputs
                              );
                       src=n;
                       memcpy(&thread.Exx[s->ndest],&src,4);
                       };
          if (s->flags & DEST_BITS16){
                       __asm("clc");
                       if (thread.EFlags & EFLG_CF)__asm("stc");
                      __asm(
                              "rcr %%cl,%%dx"
                              :"=d"(n)                       //saves in eax,edx  
                              :"c"(src),"d"(n)                 //the inputs
                              );
                       src=n;
                       memcpy(&thread.Exx[s->ndest],&src,2);
                        };
          if (s->flags & DEST_BITS8){
                       if (s->ndest <4){
                           __asm("clc");
                           if (thread.EFlags & EFLG_CF)__asm("stc");             
                           __asm(
                                  "rcr %%cl,%%dl"
                                  :"=d"(n)                       //saves in eax,edx  
                                  :"c"(src),"d"(n)                 //the inputs
                                  );
                           src=n;
                           memcpy(&thread.Exx[s->ndest],&src,1);
                       }else{
                             __asm("clc");
                             if (thread.EFlags & EFLG_CF)__asm("stc");
                             n=thread.Exx[s->ndest-4];
                             __asm(
                              "rcr %%cl,%%dh"
                              :"=d"(n)                       //saves in eax,edx  
                              :"c"(src),"d"(n)                 //the inputs
                              );
                              src=n;
                              memcpy(&thread.Exx[s->ndest-4],&src,4);
                              };
                       };
          result=thread.Exx[s->ndest];
    }else if (s->flags & DEST_RM){
          dword* ptr;
          ptr =(dword*)thread.mem->read_virtual_mem((dword)modrm_calc(thread,s));
          dword n=*ptr;
          dest=n;
          if (s->flags & DEST_BITS32){
             dword n=*ptr;
             __asm("clc");
             if (thread.EFlags & EFLG_CF)__asm("stc");
             __asm(
                   "rcr %%cl,%%edx"
                   :"=d"(n)                       //saves in eax,edx  
                   :"c"(src),"d"(n)                 //the inputs
             );
             
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)4,(char*)&n);
             
          };
          if (s->flags & DEST_BITS16){
             short n=*ptr;
             __asm("clc");
             if (thread.EFlags & EFLG_CF)__asm("stc");
             __asm(
                   "rcr %%cl,%%dx"
                   :"=d"(n)                       //saves in eax,edx  
                   :"c"(src),"d"(n)                 //the inputs
             );
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)2,(char*)&n);
          };
          if (s->flags & DEST_BITS8){
             char n=*ptr;
             __asm("clc");
             if (thread.EFlags & EFLG_CF)__asm("stc");
             __asm(
                   "rcr %%cl,%%dl"
                   :"=d"(n)                       //saves in eax,edx  
                   :"c"(src),"d"(n)                 //the inputs
             );
             thread.mem->write_virtual_mem((dword)modrm_calc(thread,s),(dword)1,(char*)&n);
          };
          result=*ptr;
    };    
    thread.updateflags(dest,0,result,0);   
    thread.EFlags &= (EFLG_PF | EFLG_ZF | EFLG_SF |EFLG_SYS);
    if (dest >> (32-src))thread.EFlags |=EFLG_CF;
    //cout << "dest= "<<(int*)dest << "\nresult= " << (int*)result<<"\nflags= "<< (int*)thread.EFlags << "\n";   
};
//----------------------------------------------------------------------
//STC
int op_stc(Thread& thread,ins_disasm* s){
    thread.EFlags |=EFLG_CF;
}
//CLC
int op_clc(Thread& thread,ins_disasm* s){
    thread.EFlags &= ~EFLG_CF;
}
